/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.ObjectHolder;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.math.*;

import javax.xml.rpc.holders.ObjectHolder;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
    private Properties props = null;

    private final static Short myShort = new Short(Short.MIN_VALUE);

    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  ObjectHolderConstructorTest1
     *
     *   @assertion_ids: JAXRPC:JAVADOC:159;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via ObjectHolder()
     *			 constructor. Verify ObjectHolder object
     *			 created successfully.
     */
    public void ObjectHolderConstructorTest1() throws Fault {
	TestUtil.logTrace("ObjectHolderConstructorTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ObjectHolder() ...");
	    ObjectHolder n = new ObjectHolder();
	    if (n != null) {
		TestUtil.logMsg(
		    "ObjectHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("ObjectHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("ObjectHolderConstructorTest1 failed", e);
        }

	if (!pass)
	    throw new Fault("ObjectHolderConstructorTest1 failed");
    }

    /*
     *   @testName:  ObjectHolderConstructorTest2
     *
     *   @assertion_ids: JAXRPC:JAVADOC:160;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via ObjectHolder(Object)
     *			 constructor. Verify ObjectHolder object
     *			 created successfully.
     */
    public void ObjectHolderConstructorTest2() throws Fault {
	TestUtil.logTrace("ObjectHolderConstructorTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg(
		"Create instance via ObjectHolder(Object) ...");
	    ObjectHolder n = new ObjectHolder(myShort);
	    if (n != null) {
		TestUtil.logMsg(
		    "ObjectHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("ObjectHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("ObjectHolderConstructorTest2 failed", e);
        }

	if (!pass)
	    throw new Fault("ObjectHolderConstructorTest2 failed");
    }

    /*
     *   @testName:  getValueTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:158;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Test using both constructors.
     *			 Verify value is set correct in each case.
     */
    public void getValueTest() throws Fault {
	TestUtil.logTrace("getValueTest");
	boolean pass = true;

	if (!getValueTest1()) pass = false;
	if (!getValueTest2()) pass = false;

	if (!pass)
	    throw new Fault("getValueTest failed");
    }

    /*
     * Create instance via ObjectHolder().
     * Verify value is set to default.
     */
    private boolean getValueTest1() throws Fault {
	TestUtil.logTrace("getValueTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via ObjectHolder() ...");
	    ObjectHolder n = new ObjectHolder();
	    if (n != null) {
		Object v = n.value;
		if (v == null)
		    TestUtil.logMsg("Value set to null as expected");
		else {
		    TestUtil.logErr("Value: expected - null" +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("ObjectHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }

	return pass;

    }

    /*
     * Create instance via ObjectHolder(Object).
     * Verify value is equal to what was set.
     */
    private boolean getValueTest2() throws Fault {
	TestUtil.logTrace("getValueTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg(
		"Create instance via ObjectHolder(Object) ...");
	    ObjectHolder n = new ObjectHolder(myShort);
	    if (n != null) {
		Short v = (Short)n.value;
		if (v.equals(myShort))
		    TestUtil.logMsg("Value set as expected to "
			+ myShort);
		else {
		    TestUtil.logErr("Value: expected - " + myShort +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("ObjectHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }

	return pass;
    }
}
