/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: XMLLangHandler.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1016;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.*;
import javax.xml.namespace.QName;
import java.util.Iterator;

public class XMLLangHandler extends GenericHandler{

    public QName [] getHeaders(){return new QName[]{};}

    public boolean handleResponse(MessageContext context){
        try{
            addXMLLangAttribute((SOAPMessageContext)context);
        }catch(SOAPException se){
            com.sun.ts.lib.util.TestUtil.printStackTrace(se);
        }
        return true;
    }

    private void addXMLLangAttribute(SOAPMessageContext context) throws SOAPException{

        Iterator children = context.getMessage().getSOAPPart().getEnvelope().getBody().getFault().getChildElements();
        SOAPElement child;
        while(children.hasNext()){
            child = (SOAPElement)children.next();
            if(child.getElementName().getLocalName().equals("faultstring")) {
                child.addAttribute(getXMLLangName(SOAPFactory.newInstance()), "en");
            }
        }
	context.getMessage().saveChanges();
    }

    private Name getXMLLangName(SOAPFactory factory) throws SOAPException{
        return factory.createName("lang", "xml", "");
    }
}
