/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: OnePropBeanSerializerFactory.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;

/**
* Serializer Factory for the OnePropBean javabean.
* Used for pluggable serializer/deserializer.
*/
public class OnePropBeanSerializerFactory implements SerializerFactory {

	protected Serializer serializer;
        protected String JAX_RPC_RI_MECHANISM =
		"http://java.sun.com/jax-rpc-ri/1.0/streaming/";

	public OnePropBeanSerializerFactory() {
		this.serializer = new OnePropBeanSOAPSerializer();
	}

	public Serializer getSerializerAs(String mechanismType)
						throws JAXRPCException {
		if (!JAX_RPC_RI_MECHANISM.equals(mechanismType)) {
			throw new JAXRPCException(
			    "typemapping.mechanism.unsupported " + mechanismType);
		}
		return serializer;
	}

	public Iterator getSupportedMechanismTypes() {
		return new SingleElementIterator(JAX_RPC_RI_MECHANISM);
	}

	public Iterator getSerializers() {
		return new SingleElementIterator(serializer);
	}
}
