/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSubmitInput
extends HtmlInput {
    private static final long serialVersionUID = -615974535731910492L;
    private static final String DEFAULT_VALUE = "Submit Query";

    HtmlSubmitInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getPage().getWebClient().getBrowserVersion().isIE() && !this.isAttributeDefined("value")) {
            this.setAttributeValue("value", DEFAULT_VALUE);
        }
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            return form.submit(this);
        }
        return super.doClickAction(defaultPage);
    }

    @Override
    public void reset() {
    }

    @Override
    public String asText() {
        String text = super.asText();
        if (text == ATTRIBUTE_NOT_DEFINED) {
            text = DEFAULT_VALUE;
        }
        return text;
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (DomAttr attribute : this.getAttributesCollection()) {
            if (attribute.getNodeName().equals("value") && attribute.getValue().equals(DEFAULT_VALUE)) continue;
            printWriter.print(" ");
            String name = attribute.getNodeName();
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)attribute.getNodeValue()));
            printWriter.print("\"");
        }
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        if (this.getNameAttribute().length() != 0 && !this.isAttributeDefined("value")) {
            return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), DEFAULT_VALUE)};
        }
        return super.getSubmitKeyValuePairs();
    }
}

