/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.Harness;
import com.sun.javatest.batch.BatchManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ListIterator;
import java.util.Vector;

class ObserverCommand
extends Command {
    private ClassLoader classLoader;
    private String className;
    private String[] classArgs;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BatchManager.class);

    static String getName() {
        return "observer";
    }

    static HelpTree.Node getHelp() {
        String[] opts = new String[]{"cp"};
        return new HelpTree.Node(i18n, "cmgr.help.observer", opts);
    }

    ObserverCommand(ListIterator argIter) throws Command.Fault {
        super(ObserverCommand.getName());
        Vector<String> v = null;
        while (argIter.hasNext()) {
            String arg = this.nextArg(argIter);
            if (arg.equals("-cp") && argIter.hasNext()) {
                this.setClassPath(this.nextArg(argIter));
                continue;
            }
            if (arg.startsWith("-")) {
                throw new Command.Fault((Command)this, i18n, "observer.badArg", arg);
            }
            this.className = arg;
            while (argIter.hasNext() && !(arg = this.nextArg(argIter)).equals("-end")) {
                if (v == null) {
                    v = new Vector<String>();
                }
                v.add(arg);
            }
            break block0;
        }
        if (this.className == null) {
            throw new Command.Fault(this, i18n, "observer.noClassName");
        }
        if (v != null) {
            this.classArgs = new String[v.size()];
            v.copyInto(this.classArgs);
        }
    }

    @Override
    public void run(CommandContext ctx) throws Command.Fault {
        try {
            Class oc = this.loadClass(this.className);
            Harness.Observer o = null;
            if (this.classArgs == null || this.classArgs.length == 0) {
                o = this.tryConstructor(oc, new Class[0], new Object[0]);
            } else if (this.classArgs.length == 1) {
                o = this.tryConstructor(oc, new Class[]{String.class}, new Object[]{this.classArgs[0]});
            }
            if (o == null) {
                o = this.tryConstructor(oc, new Class[]{String[].class}, new Object[]{this.classArgs});
            }
            if (o == null) {
                throw new Command.Fault((Command)this, i18n, "observer.cantFindConstructor", this.className);
            }
            ctx.addHarnessObserver(o);
        }
        catch (ClassNotFoundException e) {
            throw new Command.Fault((Command)this, i18n, "observer.cantFindClass", this.className);
        }
        catch (IllegalAccessException e) {
            throw new Command.Fault((Command)this, i18n, "observer.cantAccessClass", this.className);
        }
        catch (InstantiationException e) {
            throw new Command.Fault((Command)this, i18n, "observer.cantCreateClass", this.className);
        }
        catch (InvocationTargetException e) {
            throw new Command.Fault((Command)this, i18n, "observer.cantCreateClass", this.className);
        }
    }

    private Harness.Observer tryConstructor(Class obsClass, Class[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        try {
            Constructor c = obsClass.getConstructor(argTypes);
            return (Harness.Observer)c.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void setClassPath(String s) throws Command.Fault {
        char pathCh = File.pathSeparatorChar;
        Vector v = new Vector();
        int start = 0;
        int i = s.indexOf(pathCh);
        while (i != -1) {
            this.addClassPathEntry(s.substring(start, i), v);
            start = i + 1;
            i = s.indexOf(pathCh, start);
        }
        this.addClassPathEntry(s.substring(start), v);
        Object[] path = new URL[v.size()];
        v.copyInto(path);
        this.setClassPath((URL[])path);
    }

    private void setClassPath(URL[] path) {
        this.classLoader = new URLClassLoader(path);
    }

    private Class loadClass(String name) throws ClassNotFoundException {
        return this.classLoader == null ? Class.forName(name) : this.classLoader.loadClass(name);
    }

    private void addClassPathEntry(String s, Vector v) throws Command.Fault {
        try {
            if (s.length() > 0) {
                v.add(new File(s).toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new Command.Fault((Command)this, i18n, "observer.badClassPath", new Object[]{s, e});
        }
    }
}

