/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeleteNotificationDestinationExtendedRequest
extends ExtendedRequest {
    public static final String DELETE_NOTIFICATION_DESTINATION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.37";
    private static final long serialVersionUID = -2644432176543980784L;
    private final String destinationID;
    private final String managerID;

    public DeleteNotificationDestinationExtendedRequest(String managerID, String destinationID, Control ... controls) {
        super(DELETE_NOTIFICATION_DESTINATION_REQUEST_OID, DeleteNotificationDestinationExtendedRequest.encodeValue(managerID, destinationID), controls);
        this.managerID = managerID;
        this.destinationID = destinationID;
    }

    public DeleteNotificationDestinationExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DEL_NOTIFICATION_DEST_REQ_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.managerID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.destinationID = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DEL_NOTIFICATION_DEST_REQ_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(String managerID, String destinationID) {
        Validator.ensureNotNull(managerID);
        Validator.ensureNotNull(destinationID);
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(managerID), new ASN1OctetString(destinationID));
        return new ASN1OctetString(valueSequence.encode());
    }

    public String getManagerID() {
        return this.managerID;
    }

    public String getDestinationID() {
        return this.destinationID;
    }

    @Override
    public DeleteNotificationDestinationExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public DeleteNotificationDestinationExtendedRequest duplicate(Control[] controls) {
        DeleteNotificationDestinationExtendedRequest r = new DeleteNotificationDestinationExtendedRequest(this.managerID, this.destinationID, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_DEL_NOTIFICATION_DEST.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("DeleteNotificationDestinationExtendedRequest(managerID='");
        buffer.append(this.managerID);
        buffer.append("', destinationID='");
        buffer.append(this.destinationID);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

