/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MinimalLogFormatter
extends Formatter
implements Serializable {
    public static final String DEFAULT_TIMESTAMP_FORMAT = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> BUFFERS = new ThreadLocal();
    private static final long serialVersionUID = -2884878613513769233L;
    private final boolean includeLevel;
    private final boolean lineBreakAfterHeader;
    private final boolean lineBreakAfterMessage;
    private final String timestampFormat;

    public MinimalLogFormatter() {
        this(DEFAULT_TIMESTAMP_FORMAT, false, false, false);
    }

    public MinimalLogFormatter(String timestampFormat, boolean includeLevel, boolean lineBreakAfterHeader, boolean lineBreakAfterMessage) {
        this.timestampFormat = timestampFormat;
        this.includeLevel = includeLevel;
        this.lineBreakAfterHeader = lineBreakAfterHeader;
        this.lineBreakAfterMessage = lineBreakAfterMessage;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder b = BUFFERS.get();
        if (b == null) {
            b = new StringBuilder();
            BUFFERS.set(b);
        } else {
            b.setLength(0);
        }
        if (this.timestampFormat != null) {
            SimpleDateFormat f = DATE_FORMATTERS.get();
            if (f == null) {
                f = new SimpleDateFormat(this.timestampFormat);
                DATE_FORMATTERS.set(f);
            }
            b.append(f.format(new Date()));
        }
        if (this.includeLevel) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(record.getLevel().toString());
        }
        if (this.lineBreakAfterHeader) {
            b.append(StaticUtils.EOL);
        } else if (b.length() > 0) {
            b.append(' ');
        }
        b.append(this.formatMessage(record));
        if (this.lineBreakAfterMessage) {
            b.append(StaticUtils.EOL);
        }
        return b.toString();
    }
}

