/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.incubator.http.internal.hpack.DecodingCallback;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.IntegerReader;
import jdk.incubator.http.internal.hpack.StringReader;

public final class Decoder {
    private static final State[] states = new State[256];
    private final HeaderTable table;
    private State state = State.READY;
    private final IntegerReader integerReader;
    private final StringReader stringReader;
    private final StringBuilder name;
    private final StringBuilder value;
    private int intValue;
    private boolean firstValueRead;
    private boolean firstValueIndex;
    private boolean nameHuffmanEncoded;
    private boolean valueHuffmanEncoded;
    private int capacity;

    public Decoder(int n) {
        this.setMaxCapacity(n);
        this.table = new HeaderTable(n);
        this.integerReader = new IntegerReader();
        this.stringReader = new StringReader();
        this.name = new StringBuilder(512);
        this.value = new StringBuilder(1024);
    }

    public void setMaxCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity >= 0: " + n);
        }
        this.capacity = n;
    }

    public void decode(ByteBuffer byteBuffer, boolean bl, DecodingCallback decodingCallback) {
        Objects.requireNonNull(byteBuffer, "headerBlock");
        Objects.requireNonNull(decodingCallback, "consumer");
        while (byteBuffer.hasRemaining()) {
            this.proceed(byteBuffer, decodingCallback);
        }
        if (bl && this.state != State.READY) {
            throw new UncheckedIOException(new ProtocolException("Unexpected end of header block"));
        }
    }

    private void proceed(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        switch (this.state) {
            case READY: {
                this.resumeReady(byteBuffer);
                break;
            }
            case INDEXED: {
                this.resumeIndexed(byteBuffer, decodingCallback);
                break;
            }
            case LITERAL: {
                this.resumeLiteral(byteBuffer, decodingCallback);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.resumeLiteralWithIndexing(byteBuffer, decodingCallback);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.resumeLiteralNeverIndexed(byteBuffer, decodingCallback);
                break;
            }
            case SIZE_UPDATE: {
                this.resumeSizeUpdate(byteBuffer, decodingCallback);
                break;
            }
            default: {
                throw new InternalError("Unexpected decoder state: " + String.valueOf((Object)this.state));
            }
        }
    }

    private void resumeReady(ByteBuffer byteBuffer) {
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        State state = states[n];
        switch (state) {
            case INDEXED: {
                this.integerReader.configure(7);
                this.state = State.INDEXED;
                this.firstValueIndex = true;
                break;
            }
            case LITERAL: {
                this.state = State.LITERAL;
                boolean bl = this.firstValueIndex = (n & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.state = State.LITERAL_WITH_INDEXING;
                boolean bl = this.firstValueIndex = (n & 0x3F) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(6);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.state = State.LITERAL_NEVER_INDEXED;
                boolean bl = this.firstValueIndex = (n & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case SIZE_UPDATE: {
                this.integerReader.configure(5);
                this.state = State.SIZE_UPDATE;
                this.firstValueIndex = true;
                break;
            }
            default: {
                throw new InternalError(String.valueOf((Object)state));
            }
        }
        if (!this.firstValueIndex) {
            byteBuffer.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeIndexed(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        if (!this.integerReader.read(byteBuffer)) {
            return;
        }
        this.intValue = this.integerReader.get();
        this.integerReader.reset();
        try {
            HeaderTable.HeaderField headerField = this.table.get(this.intValue);
            decodingCallback.onIndexed(this.intValue, headerField.name, headerField.value);
        }
        finally {
            this.state = State.READY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteral(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        if (!this.completeReading(byteBuffer)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                HeaderTable.HeaderField headerField = this.table.get(this.intValue);
                decodingCallback.onLiteral(this.intValue, headerField.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                decodingCallback.onLiteral(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    private void resumeLiteralWithIndexing(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        if (!this.completeReading(byteBuffer)) {
            return;
        }
        try {
            String string;
            String string2 = this.value.toString();
            if (this.firstValueIndex) {
                HeaderTable.HeaderField headerField = this.table.get(this.intValue);
                string = headerField.name;
                decodingCallback.onLiteralWithIndexing(this.intValue, string, (CharSequence)string2, this.valueHuffmanEncoded);
            } else {
                string = this.name.toString();
                decodingCallback.onLiteralWithIndexing(string, this.nameHuffmanEncoded, (CharSequence)string2, this.valueHuffmanEncoded);
            }
            this.table.put(string, string2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw new UncheckedIOException((IOException)new ProtocolException().initCause(runtimeException));
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteralNeverIndexed(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        if (!this.completeReading(byteBuffer)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                HeaderTable.HeaderField headerField = this.table.get(this.intValue);
                decodingCallback.onLiteralNeverIndexed(this.intValue, headerField.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                decodingCallback.onLiteralNeverIndexed(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    private void resumeSizeUpdate(ByteBuffer byteBuffer, DecodingCallback decodingCallback) {
        if (!this.integerReader.read(byteBuffer)) {
            return;
        }
        this.intValue = this.integerReader.get();
        assert (this.intValue >= 0);
        if (this.intValue > this.capacity) {
            throw new UncheckedIOException(new ProtocolException(String.format("Received capacity exceeds expected: capacity=%s, expected=%s", this.intValue, this.capacity)));
        }
        this.integerReader.reset();
        try {
            decodingCallback.onSizeUpdate(this.intValue);
            this.table.setMaxSize(this.intValue);
        }
        finally {
            this.state = State.READY;
        }
    }

    private boolean completeReading(ByteBuffer byteBuffer) {
        if (!this.firstValueRead) {
            if (this.firstValueIndex) {
                if (!this.integerReader.read(byteBuffer)) {
                    return false;
                }
                this.intValue = this.integerReader.get();
                this.integerReader.reset();
            } else {
                if (!this.stringReader.read(byteBuffer, this.name)) {
                    return false;
                }
                this.nameHuffmanEncoded = this.stringReader.isHuffmanEncoded();
                this.stringReader.reset();
            }
            this.firstValueRead = true;
            return false;
        }
        if (!this.stringReader.read(byteBuffer, this.value)) {
            return false;
        }
        this.valueHuffmanEncoded = this.stringReader.isHuffmanEncoded();
        this.stringReader.reset();
        return true;
    }

    private void cleanUpAfterReading() {
        this.name.setLength(0);
        this.value.setLength(0);
        this.firstValueRead = false;
        this.state = State.READY;
    }

    HeaderTable getTable() {
        return this.table;
    }

    static {
        for (int i = 0; i < states.length; ++i) {
            if ((i & 0x80) == 128) {
                Decoder.states[i] = State.INDEXED;
                continue;
            }
            if ((i & 0xC0) == 64) {
                Decoder.states[i] = State.LITERAL_WITH_INDEXING;
                continue;
            }
            if ((i & 0xE0) == 32) {
                Decoder.states[i] = State.SIZE_UPDATE;
                continue;
            }
            if ((i & 0xF0) == 16) {
                Decoder.states[i] = State.LITERAL_NEVER_INDEXED;
                continue;
            }
            if ((i & 0xF0) == 0) {
                Decoder.states[i] = State.LITERAL;
                continue;
            }
            throw new InternalError(String.valueOf(i));
        }
    }

    private static enum State {
        READY,
        INDEXED,
        LITERAL_NEVER_INDEXED,
        LITERAL,
        LITERAL_WITH_INDEXING,
        SIZE_UPDATE;

    }
}

