/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.loaders;

import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;

public class ReflClassDescrLoader
implements ClassDescriptionLoader,
LoadingHints {
    public static final boolean debug = false;
    private Method forName;
    private Object[] args;
    private HashSet hints = new HashSet();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    public ReflClassDescrLoader() {
        this.args = new Object[]{"", Boolean.FALSE, this.getClass().getClassLoader()};
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ReflClassDescrLoader.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ReflClassDescrLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
        try {
            this.forName = (class$java$lang$Class == null ? (class$java$lang$Class = ReflClassDescrLoader.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredMethod("forName", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.forName = null;
        }
    }

    public ClassDescription load(String string) throws ClassNotFoundException {
        String string2 = ExoticCharTools.decodeExotic(string);
        this.args[0] = string2;
        return this.load2(string2);
    }

    private final ClassDescription load2(final String string) throws ClassNotFoundException {
        try {
            return (ClassDescription)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        if (ReflClassDescrLoader.this.forName == null) {
                            return ReflClassDescrLoader.this.loadClass(Class.forName(string));
                        }
                        return ReflClassDescrLoader.this.loadClass((Class)ReflClassDescrLoader.this.forName.invoke(null, ReflClassDescrLoader.this.args));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return ReflClassDescrLoader.this.loadClass(Class.forName(string));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (throwable instanceof LinkageError) {
                            throw (LinkageError)throwable;
                        }
                        if (throwable instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)throwable;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            SwissKnife.reportThrowable(privilegedActionException);
            throw new ClassNotFoundException(string, privilegedActionException);
        }
    }

    private ClassDescription loadClass(Class clazz) {
        ClassDescription classDescription = new ClassDescription();
        classDescription.setTiger(false);
        classDescription.setModifiers(clazz.getModifiers());
        classDescription.setupClassName(clazz.getName());
        this.setupMethods(classDescription, clazz);
        this.setupFields(classDescription, clazz);
        this.setupConstructors(classDescription, clazz);
        this.setupInterfaces(classDescription, clazz);
        this.setupNested(classDescription, clazz);
        this.setupSuperClass(classDescription, clazz);
        return classDescription;
    }

    private void setupMethods(ClassDescription classDescription, Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        classDescription.createMethods(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            classDescription.setMethod(i, ReflClassDescrLoader.createMember(methodArray[i]));
        }
    }

    private void setupFields(ClassDescription classDescription, Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        classDescription.createFields(fieldArray.length);
        for (int i = 0; i < fieldArray.length; ++i) {
            FieldDescr fieldDescr = ReflClassDescrLoader.createMember(fieldArray[i]);
            classDescription.setField(i, fieldDescr);
            String string = fieldDescr.getType();
            if (!fieldDescr.isFinal() || !PrimitiveTypes.isPrimitive(string) && !"java.lang.String".equals(string) || this.hasHint(LoadingHints.DONT_READ_VALUES)) continue;
            try {
                fieldArray[i].setAccessible(true);
                Object object = fieldArray[i].get(null);
                String string2 = MemberDescription.valueToString(object);
                fieldDescr.setConstantValue(string2);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void setupNested(ClassDescription classDescription, Class clazz) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        classDescription.createNested(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            InnerDescr innerDescr = new InnerDescr();
            classDescription.setNested(i, innerDescr);
            innerDescr.setModifiers(classArray[i].getModifiers());
            innerDescr.setupInnerClassName(classDescription.getQualifiedName(), classArray[i].getName());
            innerDescr.setupClassName(classArray[i].getName());
        }
    }

    private void setupConstructors(ClassDescription classDescription, Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        classDescription.createConstructors(constructorArray.length);
        for (int i = 0; i < constructorArray.length; ++i) {
            classDescription.setConstructor(i, ReflClassDescrLoader.createMember(constructorArray[i]));
        }
    }

    private void setupInterfaces(ClassDescription classDescription, Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        classDescription.createInterfaces(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            SuperInterface superInterface = new SuperInterface();
            classDescription.setInterface(i, superInterface);
            superInterface.setupClassName(classArray[i].getName());
        }
    }

    private void setupSuperClass(ClassDescription classDescription, Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            SuperClass superClass = new SuperClass();
            superClass.setupClassName(clazz2.getName());
            classDescription.setSuperClass(superClass);
        }
    }

    private static FieldDescr createMember(Field field) {
        FieldDescr fieldDescr = new FieldDescr(field.getName(), field.getDeclaringClass().getName(), field.getModifiers());
        fieldDescr.setType(MemberDescription.getTypeName(field.getType()));
        return fieldDescr;
    }

    private static MethodDescr createMember(Method method) {
        MethodDescr methodDescr = new MethodDescr(method.getName(), method.getDeclaringClass().getName(), method.getModifiers());
        methodDescr.setType(MemberDescription.getTypeName(method.getReturnType()));
        methodDescr.setArgs(ReflClassDescrLoader.getArgs(method.getParameterTypes()));
        methodDescr.setThrowables(ReflClassDescrLoader.getThrows(method.getExceptionTypes()));
        return methodDescr;
    }

    private static ConstructorDescr createMember(Constructor constructor) {
        ConstructorDescr constructorDescr = new ConstructorDescr(constructor.getDeclaringClass(), constructor.getModifiers());
        constructorDescr.setArgs(ReflClassDescrLoader.getArgs(constructor.getParameterTypes()));
        constructorDescr.setThrowables(ReflClassDescrLoader.getThrows(constructor.getExceptionTypes()));
        return constructorDescr;
    }

    private static String getThrows(Class[] classArray) {
        if (classArray.length == 0) {
            return "";
        }
        Object[] objectArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = classArray[i].getName();
        }
        if (classArray.length > 1) {
            Arrays.sort(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer((String)objectArray[0]);
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(",").append((String)objectArray[i]);
        }
        return stringBuffer.toString();
    }

    private static String getArgs(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(MemberDescription.getTypeName(classArray[i]));
        }
        return stringBuffer.toString();
    }

    public void addLoadingHint(LoadingHints.Hint hint) {
        this.hints.add(hint);
    }

    private boolean hasHint(LoadingHints.Hint hint) {
        return this.hints.contains(hint);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

