/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    private static final Double NaN = new Double(Double.NaN);

    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            return NumberFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("number() requires one argument.");
    }

    public static Double evaluate(Object obj, Navigator nav) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return new Double(((Number)obj).doubleValue());
        }
        if (obj instanceof Boolean) {
            if (obj == Boolean.TRUE) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            try {
                Double doubleValue = new Double(str);
                return doubleValue;
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(Double.NaN);
            }
        }
        if (obj instanceof List || obj instanceof Iterator) {
            String strValue = StringFunction.evaluate(obj, nav);
            return NumberFunction.evaluate(StringFunction.evaluate(obj, nav), nav);
        }
        if (nav.isElement(obj) || nav.isAttribute(obj)) {
            return NumberFunction.evaluate(StringFunction.evaluate(obj, nav), nav);
        }
        return new Double(Double.NaN);
    }

    public static boolean isNaN(double val) {
        return NumberFunction.isNaN(new Double(val));
    }

    public static boolean isNaN(Double val) {
        return val.equals(NaN);
    }
}

