/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Fatal;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.NamedList;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.Props;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMember;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XModifier;
import javasoft.sqe.apiCheck.XPack;
import javasoft.sqe.apiCheck.XProgComp;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypes;

class TestBase
extends XProgComp {
    PrintWriter out;
    String check;
    String mode;
    boolean sort;
    boolean values;
    boolean verbose;
    Vector msgsort;
    int errs;
    static final int CHANGE_COMP = 1;
    static final int CHANGE_SUB = 2;
    static final int CHANGE_ADD = 4;
    static final int CHANGE_OTHER = 8;
    static final int accmods = 7;
    static final int hmax = 32;
    String[] htexts = new String[32];
    boolean[] hflags = new boolean[32];
    String htext = "";
    int htos = 0;
    int htosold = 0;
    Upd upd = new Upd();

    TestBase() {
    }

    int Compare(PackageSet ps, API base, API test) {
        long t0 = Main.GetTimer();
        this.OutProps("BASE", base.props);
        this.OutProps("TEST", test.props);
        this.out.println("CHECK " + this.check);
        this.msgsort = this.sort ? new Vector() : null;
        this.errs = 0;
        this.PushHead("");
        base.GetXProg().Sort();
        this.Compare(ps, base.GetXProg(), test.GetXProg(), this.mode);
        this.PopHead();
        if (this.sort) {
            this.ReportSorted();
        }
        this.msgsort = null;
        this.out.flush();
        Main.PrintTimer("Compare", t0);
        return this.errs;
    }

    void OutProps(String msg, Props props) {
        if (props == null) {
            return;
        }
        this.out.println(msg);
        int i = 0;
        while (i < props.Size()) {
            this.out.println("//" + props.Key(i) + ": " + props.Value(i));
            ++i;
        }
        this.out.println();
    }

    void Compare(XPack base, XPack test) {
        this.PopHead();
        this.PushHead("package \"" + base.FullName() + "\"");
        super.Compare(base, test);
    }

    void Deleted(XPack xpack) {
        this.PopHead();
        this.PushHead("package \"" + xpack.FullName() + "\"");
        super.Deleted(xpack);
    }

    void Added(XPack xpack) {
        this.PopHead();
        this.PushHead("package \"" + xpack.FullName() + "\"");
        super.Added(xpack);
    }

    static boolean CompareClasses(NamedList base, NamedList test) {
        if (base.size() != test.size()) {
            return false;
        }
        Vector temp = (Vector)test.clone();
        int i = 0;
        while (i < base.size()) {
            String name = ((XClass)base.elementAt(i)).FullName();
            int k = 0;
            while (k < temp.size()) {
                if (name.equals(((XClass)temp.elementAt(k)).FullName())) {
                    temp.removeElementAt(k);
                    name = null;
                    break;
                }
                ++k;
            }
            if (name != null) {
                return false;
            }
            ++i;
        }
        return temp.size() == 0;
    }

    static boolean CompareTypes(XTypes base, XTypes test) {
        if (base.size() != test.size()) {
            return false;
        }
        Vector temp = (Vector)test.clone();
        int i = 0;
        while (i < base.size()) {
            XType t = (XType)base.elementAt(i);
            int k = 0;
            while (k < temp.size()) {
                if (t.equals(temp.elementAt(k))) {
                    temp.removeElementAt(k);
                    t = null;
                    break;
                }
                ++k;
            }
            if (t != null) {
                return false;
            }
            ++i;
        }
        return temp.size() == 0;
    }

    static String ClassesToString(NamedList tt) {
        String s = "";
        Enumeration e = tt.elements();
        while (e.hasMoreElements()) {
            if (s.length() != 0) {
                s = s + ',';
            }
            s = s + ((XClass)e.nextElement()).FullName();
        }
        return s;
    }

    void TestBits(String pref, int mb, int mt, int type) {
        int mx = mb ^ mt;
        int m = 1;
        while (mx != 0) {
            int bb = mb & m;
            int bt = mt & m;
            if (bb != bt) {
                if (bb != 0) {
                    this.Report(type, "modifier deleted:", pref + "\"" + XModifier.toString(bb) + "\"");
                } else {
                    this.Report(type, "modifier added:", pref + "\"" + XModifier.toString(bt) + "\"");
                }
            }
            mx >>= 1;
            m <<= 1;
        }
    }

    void PushHead(String hd) {
        if (this.htos == 32) {
            Fatal.Stop("Heads stack overflow");
        }
        this.htexts[this.htos] = new String(hd);
        this.hflags[this.htos] = true;
        ++this.htos;
    }

    void PopHead() {
        this.htexts[this.htos] = null;
        --this.htos;
    }

    void ReportSorted() {
        Collections.sort(this.msgsort);
        String kind = "";
        String context = "";
        int i = 0;
        while (i < this.msgsort.size()) {
            Msg m = (Msg)this.msgsort.elementAt(i);
            if (!m.kind.equals(kind)) {
                kind = m.kind;
                this.out.println("\n" + kind);
                context = "";
            }
            if (!m.context.equals(context)) {
                context = m.context;
                this.out.println("\t" + context);
            }
            this.out.print(String.valueOf(TestBase.TypeChar(m.type)));
            this.out.println("\t\t" + m.text);
            ++i;
        }
    }

    void Report(int type, String kind, String text) {
        if (this.msgsort == null) {
            int i = 0;
            while (i < this.htos) {
                if (this.hflags[i]) {
                    this.hflags[i] = false;
                    this.out.println();
                    this.out.print(TestBase.Indent(i));
                    this.out.println(this.htexts[i]);
                    this.htosold = this.htos;
                }
                ++i;
            }
            if (this.htos < this.htosold) {
                this.out.println();
                this.htosold = this.htos;
            }
            this.out.print(String.valueOf(TestBase.TypeChar(type)));
            this.out.print(TestBase.Indent(this.htos));
            this.out.print(kind + ' ' + text);
            this.out.println();
        } else {
            Msg m = new Msg();
            m.context = this.htexts[this.htos - 1];
            m.type = type;
            m.kind = kind;
            m.text = text;
            this.msgsort.addElement(m);
        }
        ++this.errs;
    }

    static char TypeChar(int t) {
        switch (t) {
            case 0: {
                return ' ';
            }
            case 1: {
                return ' ';
            }
            case 2: {
                return '-';
            }
            case 4: {
                return '+';
            }
            case 8: {
                return '#';
            }
        }
        return '?';
    }

    static String Indent(int n) {
        String s = "";
        int i = n;
        while (i > 0) {
            s = s + "\t";
            --i;
        }
        return s;
    }

    static {
        CHANGE_COMP = 1;
        CHANGE_SUB = 2;
        CHANGE_ADD = 4;
        CHANGE_OTHER = 8;
        accmods = 7;
        hmax = 32;
    }

    class Upd {
        PrintWriter out;
        static final int CHANGE = 0;
        static final int ADD = 1;
        static final int DELETE = 2;
        int curop = -1;
        Context cur = new Context();
        int depth = 0;

        Upd() {
        }

        void Change(XClassMember x, XClassMember y) {
            if (this.out != null) {
                Context cx = new Context(x);
                Context cy = new Context(y);
                if (cx.defpack.equals(cy.defpack) && cx.defclass.equals(cy.defclass)) {
                    this.SetContext(cx);
                } else {
                    this.SetContext(new Context());
                }
                this.curop = 0;
                this.out.println();
                this.out.println("#CHANGE");
                this.out.println(this.Descr(x));
                this.out.println("#TO");
                this.out.println(this.Descr(y));
                this.out.println("#END");
            }
        }

        void Add(XClassMember x) {
            if (this.out != null) {
                if (this.SetContext(new Context(x)) || this.curop != 1) {
                    this.curop = 1;
                    this.out.println();
                    this.out.println("#ADD");
                }
                this.out.println(this.Descr(x));
            }
        }

        void Delete(XClassMember x) {
            if (this.out != null) {
                if (this.SetContext(new Context(x)) || this.curop != 2) {
                    this.curop = 2;
                    this.out.println();
                    this.out.println("#DELETE");
                }
                this.out.println(this.Descr(x));
            }
        }

        String Descr(XClassMember x) {
            if (x instanceof XClass) {
                return this.Descr((XClass)x);
            }
            if (x instanceof XClassConstructor) {
                return this.Descr((XClassConstructor)x);
            }
            if (x instanceof XClassMethod) {
                return this.Descr((XClassMethod)x);
            }
            if (x instanceof XClassField) {
                return this.Descr((XClassField)x);
            }
            return "???";
        }

        String Descr(XClass x) {
            String s = "";
            if ((s = s + XModifier.toString(x.modifier & 0xFFFFFDFF)).length() != 0) {
                s = s + " ";
            }
            if (x.IsInterface()) {
                s = s + "interface " + this.RelativeName(x);
                if (x.implement.size() != 0) {
                    s = s + " extends " + TestBase.ClassesToString(x.implement);
                }
            } else {
                s = s + "class " + this.RelativeName(x);
                if (x.extend != null && !x.extend.FullName().equals("java.lang.Object")) {
                    s = s + " extends " + x.extend.FullName();
                }
                if (x.implement.size() != 0) {
                    s = s + " implements " + TestBase.ClassesToString(x.implement);
                }
            }
            if (this.curop == 1) {
                s = s + " {\n";
                ++this.depth;
                Enumeration e = x.constructors.elements();
                while (e.hasMoreElements()) {
                    s = s + TestBase.Indent(this.depth) + this.Descr((XClassConstructor)e.nextElement()) + "\n";
                }
                Enumeration e2 = x.methods.elements();
                while (e2.hasMoreElements()) {
                    s = s + TestBase.Indent(this.depth) + this.Descr((XClassMethod)e2.nextElement()) + "\n";
                }
                Enumeration e3 = x.fields.elements();
                while (e3.hasMoreElements()) {
                    s = s + TestBase.Indent(this.depth) + this.Descr((XClassField)e3.nextElement()) + "\n";
                }
                Enumeration e4 = x.inners.elements();
                while (e4.hasMoreElements()) {
                    s = s + TestBase.Indent(this.depth) + this.Descr((XClass)e4.nextElement()) + "\n";
                }
                --this.depth;
                return s + TestBase.Indent(this.depth) + "}";
            }
            return s + " {}";
        }

        String Descr(XClassConstructor x) {
            String s = XModifier.toString(x.modifier);
            if (s.length() != 0) {
                s = s + " ";
            }
            s = s + this.RelativeName(x);
            if (x.xthrows.size() != 0) {
                s = s + " throws " + x.xthrows.toString();
            }
            return s + ";";
        }

        String Descr(XClassMethod x) {
            String s = XModifier.toString(x.modifier);
            if (s.length() != 0) {
                s = s + " ";
            }
            s = s + x.type.toString() + " " + this.RelativeName(x);
            if (x.xthrows.size() != 0) {
                s = s + " throws " + x.xthrows.toString();
            }
            return s + ";";
        }

        String Descr(XClassField x) {
            String s = XModifier.toString(x.modifier);
            if (s.length() != 0) {
                s = s + " ";
            }
            return s + x.type.toString() + " " + this.RelativeName(x) + ";";
        }

        String RelativeName(XClassMember x) {
            if (this.depth == 0 && this.cur.Empty()) {
                if (x instanceof XClass) {
                    return x.FullName();
                }
                return x.home.FullName() + "." + x.toString();
            }
            return x.toString();
        }

        boolean SetContext(Context c) {
            boolean changed = false;
            if (!this.cur.defpack.equals(c.defpack)) {
                this.cur.defpack = c.defpack;
                this.cur.defclass = "";
                this.out.println();
                this.out.println("#PACKAGE " + this.cur.defpack);
                changed = true;
            }
            if (!this.cur.defclass.equals(c.defclass)) {
                this.cur.defclass = c.defclass;
                if (!changed) {
                    this.out.println();
                }
                this.out.println("#CLASS " + this.cur.defclass);
                changed = true;
            }
            return changed;
        }

        static {
            CHANGE = 0;
            ADD = 1;
            DELETE = 2;
        }
    }

    static class Context {
        String defpack = "";
        String defclass = "";

        Context() {
            this.defclass = "";
            this.defpack = "";
        }

        Context(XClassMember x) {
            String string = this.defpack = x instanceof XClass ? ((XClass)x).pack.FullName() : x.home.pack.FullName();
            if (x instanceof XClass) {
                XClass w = (XClass)x;
                this.defpack = w.pack.FullName();
                this.defclass = w.home == null ? "" : w.home.FullName();
            } else {
                this.defpack = x.home.pack.FullName();
                this.defclass = x.home.FullName();
            }
            int i = this.defpack.length();
            if (i != 0 && i < this.defclass.length()) {
                this.defclass = this.defclass.substring(i + 1);
            }
        }

        boolean Empty() {
            return this.defpack.length() == 0 && this.defpack.length() == 0;
        }
    }

    static class Msg
    implements Comparable {
        int type;
        String context;
        String kind;
        String text;

        Msg() {
        }

        public int compareTo(Object o) {
            Msg m = (Msg)o;
            return (this.kind + this.context + this.text).compareTo(m.kind + m.context + m.text);
        }
    }
}

