/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientrequestcontext;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

import com.sun.ts.lib.harness.EETest.Fault;

@Provider
/**
 * Counter should remain the same as any change would suggest that the 
 * getPropertyNames collection is not immutable 
 */
public class GetPropertyNamesIsImmutableProvider extends ContextProvider {
	private AtomicInteger counter;
	public static final String NEWNAME = "AnyNewNameAddedToPropertyNames";

	public GetPropertyNamesIsImmutableProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}

	@Override
	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		Collection<String> properties = context.getPropertyNames();
		try {
			properties.add(NEWNAME);
		} catch (Exception e) {
			// any possible exception here is ok as collection should be
			// immutable
		}
		properties = context.getPropertyNames();
		if (properties.contains(NEWNAME))
			counter.set(counter.get() + 100);
		context.abortWith(Response.ok(counter.get()).build());
	}
}
