/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientrequestcontext;

import java.util.concurrent.atomic.AtomicInteger;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Response;

import com.sun.ts.lib.harness.EETest.Fault;

public class RemovePropertyProvider extends ContextProvider {
	private AtomicInteger counter;
	
	public RemovePropertyProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}
	
	@Override
	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {		
		String propName = "PROPERTY";
		switch (counter.incrementAndGet()) {
		case 1:
			Object property = context.getProperty(propName);
			assertFault(property == null, "property already exist");
			context.setProperty(propName, propName);
			break;
		case 2:
			property = context.getProperty(propName);
			assertFault(property != null, "property not exist");
			context.removeProperty(propName);
			break;
		case 3:
			property = context.getProperty(propName);
			assertFault(property == null, "property already exist");
			Response response = Response.ok("NULL").build();
			context.abortWith(response);
			break;
		}
	}	

	/**
	 * @param conditionTrue
	 * @param message
	 * @throws Fault
	 * 		when conditionTrue is not met with message provided
	 */
	protected static void //
	assertFault(boolean conditionTrue, Object... message) throws Fault {
		if (!conditionTrue) {
			StringBuilder sb = new StringBuilder();
			for (Object msg : message)
				sb.append(msg).append(" ");
			throw new Fault(sb.toString());
		}
	}	

}
