/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ExceptionThrowingStringBeanEntityProvider.java 69498 2013-01-14 14:49:15Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.reader.readerinterceptorcontext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

@Provider
public class ExceptionThrowingStringBeanEntityProvider implements MessageBodyReader<ExceptionThrowingStringBean>, MessageBodyWriter<ExceptionThrowingStringBean> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) { 
		return type == ExceptionThrowingStringBean.class;
	}

	@Override
	public long getSize(ExceptionThrowingStringBean t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType) {
		return t.get().length();
	}

	@Override
	public void writeTo(ExceptionThrowingStringBean t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(t.get().getBytes());
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return isWriteable(type, genericType, annotations, mediaType);
	}

	@Override
	public ExceptionThrowingStringBean readFrom(
			Class<ExceptionThrowingStringBean> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		String entity = JaxrsUtil.readFromStream(entityStream);
		entityStream.close();
		return new ExceptionThrowingStringBean(entity);
	}

}
