/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InterceptorTwoBody.java 69498 2013-01-14 14:49:15Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.reader.readerinterceptorcontext;

import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptorContext;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;
import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

public class InterceptorTwoBody extends
		TemplateInterceptorBody<ReaderInterceptorContext> {
	@Override
	protected Object operationMethodNotFound(String operation)
			throws IOException {
		return proceed();
	}

	public void getHeadersIsMutable() {
		MultivaluedMap<String, String> headers = context.getHeaders();
		String first = headers.getFirst(PROPERTY);
		setEntity(first == null ? NULL : PROPERTY);
	}
	
	public void proceedThrowsIOException() throws IOException {
		throw new IOException("Interceptor#proceed IOException tck test");
	}
	
	public Object proceedThrowsWebAppException() throws WebApplicationException, IOException {
		return context.proceed();
	}	
	
	public void setInputStream() throws IOException {
		InputStream stream = context.getInputStream(); 
		String entity = JaxrsUtil.readFromStream(stream);
		setEntity(NULL.equals(entity) ? ENTITY2 : NULL);
	}
}
