/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.jaxrs.common.provider;

import javax.ws.rs.ext.ParamConverter;

import com.sun.ts.tests.jaxrs.common.provider.StringBean;

public class StringBeanParamConverter implements ParamConverter<StringBean> {
	
	public static final String VALUE = "Converted value: ";

	@Override
	public StringBean fromString(String value) throws IllegalArgumentException {
		return new StringBean(VALUE + value);
	}

	@Override
	public String toString(StringBean value) throws IllegalArgumentException {
		return VALUE + value.get();
	}

}
