/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.resource.webappexception.mapper;

import java.io.IOException;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

@Path(value = "resource")
public class Resource {

	@GET
	@Path("noresponse")
	public String noresponse() {
		throw new WebApplicationException();
	}

	@GET
	@Path("responseok")
	public String responseOk() {
		Response r = Response.ok().build();
		throw new WebApplicationException(r);
	}

	@GET
	@Path("responsestatusok")
	public String responseStatusOk() {
		throw new WebApplicationException(Status.OK);
	}
	
	@GET
	@Path("responseentity")
	public String responseEntity(){
		Response r = Response.ok(getClass().getSimpleName()).build();
		throw new WebApplicationException(r);
	}

	@GET
	@Path("responsestatusintok")
	public String responseStatusIntOk() {
		throw new WebApplicationException(Status.OK.getStatusCode());
	}
	
	@GET
	@Path("responsethrowable")
	public String responseThrowable() {
		throw new WebApplicationException(getIOException());
	}	

	@GET
	@Path("responsethrowableok")
	public String responseThrowableOk() {
		Response r = Response.ok().build();
		throw new WebApplicationException(getIOException(), r);
	}

	@GET
	@Path("responsestatusthrowableok")
	public String responseThrowableStatusOk() {
		throw new WebApplicationException(getIOException(), Status.OK);
	}

	@GET
	@Path("responsestatusthrowableintok")
	public String responseThrowableStatusIntOk() {
		throw new WebApplicationException(getIOException(),
				Status.OK.getStatusCode());
	}
	
	@GET
	@Path("uncheckedexception")
	public String throwIOExecption() {
		throw new ClassCastException("ERROR");
	}	
	
	IOException getIOException() {
		IOException ioe = new IOException("You should NOT see this message");
		return ioe;
	}

}
