/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.ee.rs.client.clientrequestcontext;

import java.util.Collection;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;

@Path("resource")
public class Resource {

	@POST
	@Path("post")
	public String post(String value) {
		return value;
	}

	@PUT
	@Path("put")
	public String put(String value) {
		return value;
	}

	@GET
	@Path("headers")
	public String headers(@Context HttpHeaders headers) {
		String hdrs = collectionToString(headers.getRequestHeaders().keySet());
		return hdrs;
	}

	protected static <T> String collectionToString(Collection<T> collection) {
		StringBuilder sb = new StringBuilder();
		for (T t : collection)
			sb.append(t).append(";");
		return sb.toString();
	}

}
