/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.containerwriter;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/**
 * Client with given ContextOperation enum, so that an enum name is passed as a
 * http header to an interceptor. Due to the ContextOperation, the proper method
 * on an interceptor is called.
 * 
 * @param <CONTEXTOPERATION>
 */
public abstract class WriterClient<CONTEXTOPERATION extends Enum<?>> extends
		JaxrsCommonClient {

	private static final long serialVersionUID = -9222693803307311300L;

	/**
	 * Invoke and convert CONTEXTOPERATION to a path
	 */
	protected void invoke(CONTEXTOPERATION op) throws Fault {
		setProperty(Property.REQUEST,
				buildRequest(Request.GET, op.name().toLowerCase()));
		super.invoke();
	}

	/**
	 * Invoke and convert CONTEXTOPERATION to a path
	 */
	protected void invoke(CONTEXTOPERATION op, Request method) throws Fault {
		setProperty(Property.REQUEST,
				buildRequest(method, op.name().toLowerCase()));
		super.invoke();
	}

}
