/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InterceptorBodyTwo.java 69513 2013-01-15 12:49:59Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.writer.writerinterceptorcontext;

import java.io.IOException;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptorContext;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;

public class InterceptorBodyTwo extends
		TemplateInterceptorBody<WriterInterceptorContext> {
	@Override
	protected Object operationMethodNotFound(String operation)
			throws IOException {
		return proceed();
	}
	
	public void getHeadersIsMutable() {
		MultivaluedMap<String, Object> headers = context.getHeaders();
		Object o = headers.getFirst(PROPERTY);
		assertTrue(o != null, PROPERTY, "header NOT found");
		setEntity(o);
	}
	
	public void proceedThrowsIOException() throws IOException {
		throw new IOException("Interceptor test IoException");
	}
	
	public void proceedThrowsWebAppException() throws IOException {
		context.proceed();
	}
	
	public void setEntity(){
		Object entity = context.getEntity();
		setEntity(entity);
	}
}
