/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs.put;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

public class JAXRSClient extends JaxrsCommonClient {

	private static final long serialVersionUID = -71817508809693264L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_ee_rs_put_web");
	}

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/*
	 * @class.setup_props: webServerHost;
	 *                     webServerPort;
	 *                     ts_home;
	 */
	/* Run test */
	/*
	 * @testName: putTest1
	 * @assertion_ids: JAXRS:SPEC:20.1;
	 *                 JAXRS:JAVADOC:6; JAXRS:JAVADOC:8; JAXRS:JAVADOC:10;
	 * @test_Strategy: Client invokes PUT on root resource at /PutTest;
	 *                 Verify that right Method is invoked.
	 */
	public void putTest1() throws Fault {
		setProperty(Property.REQUEST_HEADERS, "Accept:text/plain");
		setProperty(Property.CONTENT, "dummy");
		setProperty(Property.REQUEST, buildRequest(Request.PUT, "PutTest"));
		setProperty(Property.SEARCH_STRING, "CTS-put text/plain");
		invoke();
	}

	/*
	 * @testName: putTest2
	 * @assertion_ids: JAXRS:SPEC:20.1;
	 *                 JAXRS:JAVADOC:6; JAXRS:JAVADOC:8; JAXRS:JAVADOC:10;
	 * @test_Strategy: Client invokes PUT on root resource at /PutTest;
	 *                 Verify that right Method is invoked.
	 */
	public void putTest2() throws Fault {
		setProperty(Property.CONTENT, "dummy");
		setProperty(Property.REQUEST_HEADERS, "Accept:text/html");
		setProperty(Property.REQUEST, buildRequest(Request.PUT, "PutTest"));
		setProperty(Property.SEARCH_STRING, "CTS-put text/html");
		invoke();
	}

	/*
	 * @testName: putSubTest
	 * @assertion_ids: JAXRS:SPEC:20.1;
	 *                 JAXRS:JAVADOC:6; JAXRS:JAVADOC:8; JAXRS:JAVADOC:10;
	 * @test_Strategy: Client invokes PUT on a sub resource at /PutTest/sub;
	 *                 Verify that right Method is invoked.
	 */
	public void putSubTest() throws Fault {
		setProperty(Property.CONTENT, "dummy");
		setProperty(Property.REQUEST, buildRequest(Request.PUT, "PutTest/sub"));
		setProperty(Property.SEARCH_STRING, "CTS-put text/html");
		invoke();
	}
}
