/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StageCheckerResource.java 75009 2017-05-30 16:19:04Z jsupol $ 
 */
package com.sun.ts.tests.jaxrs.jaxrs21.ee.sse.sseeventsink;

import static com.sun.ts.tests.jaxrs.jaxrs21.ee.sse.SSEJAXRSClient.MESSAGE;

import java.util.concurrent.CompletableFuture;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;

@Path("stage")
public class StageCheckerResource {
	public static final String DONE = "CompletionStage has been done";

	@GET
	@Produces(MediaType.SERVER_SENT_EVENTS)
	public void send(@Context SseEventSink sink, @Context Sse sse) {
		try (SseEventSink s = sink) {
			CompletableFuture<?> stage = s.send(sse.newEvent(MESSAGE)).toCompletableFuture();
			while (!stage.isDone()) {
				try {
					Thread.sleep(200L);
				} catch (InterruptedException e) {
					e.printStackTrace();
					sse.newEvent(e.getMessage());
					return;
				}
			}
			s.send(sse.newEvent(DONE));
		}
	}
}
