/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Resource.java 69516 2013-01-15 14:05:39Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.client.typedentities;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

import com.sun.ts.tests.jaxrs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;

@Path("resource")
public class Resource {

	@GET
	@Path("readerprovider")
	public ReadableWritableEntity clientReader() {
		return new ReadableWritableEntity(getClass().getName());
	}

	@POST
	@Path("writerprovider")
	public String clientWriter(ReadableWritableEntity entity) {
		return entity.toXmlString();
	}
	
	
	@GET
	@Path("standardreader")
	public String bytearrayreader(@Context HttpHeaders headers){
		String name = Resource.class.getName(); 
		MediaType type = headers.getAcceptableMediaTypes().iterator().next();
		if (type != null && type.getSubtype().contains("xml"))
			name = "<resource>" + name + "</resource>";
		return name;
	}
	
	@POST
	@Path("standardwriter")
	public String bytearraywriter(String value){
		return value;
	}
}
