/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSClient.java 69718 2013-01-31 11:55:55Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.dynamicfeature;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
/**
 * Test the interceptor is called when any entity provider is called
 */
public class JAXRSClient extends JaxrsCommonClient {

	private static final long serialVersionUID = 1177743379402950754L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_spec_filter_dynamicfeature_web/resource");
	}

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */

	/*
	 * @testName: noBindingTest
	 * @assertion_ids: JAXRS:JAVADOC:987; 
	 * @test_Strategy: When a filter or interceptor method throws an exception, 
	 * 					the JAX-RS runtime will attempt to map the exception
	 * 
	 * 					If a web resource had been matched before the exception 
	 * 					was thrown, then all the filters in the ContainerResponse 
	 * 					chain for that resource MUST be invoked;
	 *  
	 */
	public void noBindingTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "nobinding"));
		setProperty(Property.CONTENT, "0");
		setProperty(Property.SEARCH_STRING, "0");
		invoke();
		logMsg("Dynamic Bynding did not bind any filter or interceptor as expected");
	}

	/*
	 * @testName: dynamicBindingTest
	 * @assertion_ids: JAXRS:JAVADOC:987; 
	 * @test_Strategy: When a filter or interceptor method throws an exception, 
	 * 					the JAX-RS runtime will attempt to map the exception
	 * 
	 * 					If a web resource had been matched before the exception 
	 * 					was thrown, then all the filters in the ContainerResponse 
	 * 					chain for that resource MUST be invoked;
	 *  
	 */
	public void dynamicBindingTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "dynamic"));
		setProperty(Property.CONTENT, "0");
		setProperty(Property.SEARCH_STRING, "12");
		invoke();
		logMsg("Dynamic feature bound filter and interceptor as expected");
	}	
}
