/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: FirstReaderInterceptor.java 69965 2013-02-13 12:02:10Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.lastvalue;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(100)
public class FirstReaderInterceptor implements ReaderInterceptor {

	@Override
	public Object aroundReadFrom(ReaderInterceptorContext context)
			throws IOException, WebApplicationException {
		MultivaluedMap<String, String> headers = context.getHeaders();
		String header = headers.getFirst(Resource.HEADERNAME);
		if (header != null && header.equals(getClass().getName())) {
			context.setAnnotations(Resource.class.getAnnotations());			
			context.setInputStream(new ByteArrayInputStream(getClass()
					.getName().getBytes()));
			context.setMediaType(MediaType.TEXT_HTML_TYPE);
			context.setType(LinkedList.class);
		}
		return context.proceed();
	}

}
