/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */
package com.sun.ts.tests.jaxrs.spec.provider.overridestandard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.activation.DataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class TckDataSourceProvider extends AbstractProvider implements
MessageBodyReader<DataSource>, MessageBodyWriter<DataSource> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return DataSource.class.isAssignableFrom(type);
	}

	@Override
	public long getSize(DataSource t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return getLength();
	}

	@Override
	public void writeTo(DataSource t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(t.getName().getBytes());
		entityStream.write(getWriterName().getBytes());
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return isWriteable(type, genericType, annotations, mediaType);
	}

	@Override
	public DataSource readFrom(Class<DataSource> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		DataSource ds = new DataSource() {
			
			@Override
			public OutputStream getOutputStream() throws IOException {
				return null;
			}
			
			@Override
			public String getName() {
				return getReaderName();
			}
			
			@Override
			public InputStream getInputStream() throws IOException {
				return null;
			}
			
			@Override
			public String getContentType() {
				return MediaType.WILDCARD;
			}
		};
		return ds;
	}

}
