/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 70490 2013-03-07 15:01:56Z supol $
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;

@Path("resource")
public class Resource {

	@Path("contextresolver")
	@GET
	public Response contextresolver(@Context Providers providers) {
		ContextResolver<HolderClass> holder = providers.getContextResolver(
				HolderClass.class, MediaType.WILDCARD_TYPE);
		return holder.getContext(HolderClass.class).toResponse();
	}

	@Path("exceptionmapper")
	@GET
	public String exceptionMapper() {
		throw new VisibilityException();
	}

	@Path("bodywriter")
	@GET
	public DummyClass bodyWriter() {
		return new DummyClass();
	}

	@Path("bodyreader")
	@POST
	public String bodyWriter(String text) {
		return text;
	}

}
