/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.resource.requestmatching;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ExceptionMatcher implements
		ExceptionMapper<WebApplicationException> {

	@Override
	public Response toResponse(WebApplicationException exception) {
		Response response = exception.getResponse();
		int status = response == null ? Status.INTERNAL_SERVER_ERROR
				.getStatusCode() : response.getStatus();
		if (response != null && response.getEntity() != null)
			return response;
		switch (status) {
		case 404:
		case 405:
		case 406:
		case 415:
			return Response.ok(String.valueOf(status)).build();
		}
		return response;
	}

}
