/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.resource.requestmatching;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("resource/subresource")
public class MainSubResource {
	public static final String ID = "subresource";

	@GET
	public String subresource() {
		return this.getClass().getSimpleName();
	}

	@POST
	@Path("sub")
	@Consumes(MediaType.TEXT_PLAIN)
	@Produces(MediaType.TEXT_PLAIN)	
	public String sub() {
		return this.getClass().getSimpleName();
	}

	@GET
	@Path("{id}")
	public String neverHere() {
		return ID;
	}

	@POST
	@Path("consumes")
	@Consumes(MediaType.TEXT_PLAIN)
	public String consumes() {
		return getClass().getSimpleName();
	}

	@Path("consumeslocator")
	public AnotherResourceLocator consumeslocator() {
		return new AnotherResourceLocator();
	}

	@POST
	@Path("produces")
	@Produces(MediaType.TEXT_PLAIN)
	public String produces() {
		return getClass().getSimpleName();
	}

	@Path("produceslocator")
	public AnotherResourceLocator produceslocator() {
		return new AnotherResourceLocator();
	}

}
