/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ReturnTypeTest.java 69965 2013-02-13 12:02:10Z supol $
 */
package com.sun.ts.tests.jaxrs.spec.returntype;

import java.util.UUID;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;
import javax.ws.rs.ext.RuntimeDelegate;

import com.sun.ts.tests.jaxrs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;

@Path(value = "/ReturnTypeTest")
public class ReturnTypeTest {

	public static final long serialVersionUID = 6121223518891332649L;

	@GET
	@Path("void")
	public String voidTest() {
		return null;
	}

	@GET
	@Path("nullResponse")
	public Response nullResponse() {
		return null;
	}
	
	@GET
	@Path("nullEntityResponse")
	public Response nullEntityResponse() {
		RuntimeDelegate rd = RuntimeDelegate.getInstance();
		ResponseBuilder rb = rd.createResponseBuilder();
		return rb.entity(null).build();
	}	

	@GET
	@Path("default")
	public String defaultTest() {
		return "I am OK";
	}

	@GET
	@Produces(MediaType.TEXT_PLAIN)
	@Path("notAcceptable")
	public String notAcceptableTest() {
		return "I am OK";
	}

	@GET
	@Path("nullGenericEntityTest")
	public GenericEntity<?> nullGenericEntityTest() {
		return null;
	}

	@GET
	@Path("genericEntityTest")
	public GenericEntity<UUID> genericEntityTest() {
		UUID uuid = new UUID(serialVersionUID, serialVersionUID >> 1);
		return new GenericEntity<UUID>(uuid, uuid.getClass()
				.getGenericSuperclass());
	}

	@GET
	@Path("nullEntityTest")	
	public ReadableWritableEntity nullEntity() {
		return null;
	}
	
	@GET
	@Path("entitybodytest")	
	@Produces(MediaType.TEXT_XML)
	public ReadableWritableEntity entityTest() {
		return new ReadableWritableEntity(String.valueOf(serialVersionUID));
	}
	
	@GET
	@Path("entitybodyresponsetest")
	public Response entityResponseTest() {
		RuntimeDelegate rd = RuntimeDelegate.getInstance();
		ResponseBuilder rb = rd.createResponseBuilder();
		ReadableWritableEntity rwe = entityTest();
		return rb.entity(rwe).build();
	}	
	
}
