/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.elementcollection;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

/*
 * Customer
 */

@Entity
@Table(name = "CUST_TABLE")
@Access(AccessType.FIELD)
public class Customer implements java.io.Serializable {

    // Instance variables
    @Id
    @Column(name = "CUST_ID")
    private String id;

    @Column(name = "NAME")
    private String name;

    @ElementCollection
    @CollectionTable(
            name="PHONES",
            joinColumns=@JoinColumn(name="ID")
    )
    @Column(name="PHONE_NUMBER")
    private List<String> phones = new ArrayList<String>();

    public Customer() {
    }

    public Customer(String id) {
        this.id = id;
    }

    public Customer(String id, String name) {
        this.id = id;
        this.name = name;
    }

    // ===========================================================
    // getters and setters for CMP fields


    public String getId() {
        return id;
    }

    public void setId(String v) {
        this.id = v;
    }


    public String getName() {
        return name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public List<String> getPhones() {
        return this.phones;
    }

    public void setPhones(List<String> phones) {
        this.phones=phones;
    }

    public boolean equals(Object o) {
        Customer other;
        boolean same = true;

        if (!(o instanceof Customer)) {
            return false;
        }
        other = (Customer) o;

        same &= this.id.equals(other.id);

        return same;
    }


    public int hashCode() {
        int myHash;

        myHash = this.id.hashCode();

        return myHash;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getName() != null) {
            result.append(", name: " + getName());
        } else {
            result.append(", name: null");
        }
         if (phones.size() > 0) {
            int size = phones.size();
            result.append(", phones[");
            int i=0;
            for (String s : phones) {
                result.append(s);
                i++;
                if (i<size){
                    result.append(",");
                }
            }
            result.append("]");

        } else {
            result.append(", phones: null");
        }
        result.append("]");
        return result.toString();
    }
}
