/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import com.sun.ts.lib.util.TestUtil;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Entity
@Table(name = "DATATYPES3")
public class FieldBigDecimalId implements java.io.Serializable {

    // ===========================================================
    // instance variables

    @Id
    @Column(name = "ID")
    protected BigDecimal id;

    @Column(name = "THEVALUE")
    private BigDecimal bigDecimal;


    // ===========================================================
    // constructors
    public FieldBigDecimalId() {
        TestUtil.logTrace("Entity A no arg constructor");
    }

    public FieldBigDecimalId(BigDecimal id, BigDecimal bigDecimal) {

        this.id = id;
        this.bigDecimal = bigDecimal;

    }


    public BigDecimal getId() {
        return id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         if (getBigDecimal() != null){
             result.append(", BigDecimal: " + getBigDecimal());
         } else {
             result.append(", BigDecimal: null");
         }
         result.append("]");
         return result.toString();
     }
}
