/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
/*
 * $Id: Employee.java 62939 2011-06-02 20:58:19Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.annotations.mapkey;

import javax.persistence.*;
import java.sql.Date;

/*
 * Employee
 */
@Cacheable(false)
@Entity
@Table(name="EMPLOYEE")
public class Employee3 implements java.io.Serializable {

    private int	     	     id;
    private String	     firstName;
    private String	     lastName;
    private Date	     hireDate;
    private float	     salary;
    private Department       department;

    public Employee3() {
    }

    public Employee3(int id, String firstName, String lastName)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
    }

    public Employee3(int id, String firstName, String lastName, Date hireDate, float salary)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
		this.hireDate = hireDate;
		this.salary = salary;
    }

    public Employee3(int id, String firstName, String lastName, Date hireDate, float salary, Department department)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
		this.hireDate = hireDate;
		this.salary = salary;
        	this.department = department;
    }

   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME",insertable = true, updatable = false)
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATE")
    public Date getHireDate() {
        return hireDate;
    }
    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return salary;
    }
    public void setSalary(float salary) {
        this.salary = salary;
    }

   // ===========================================================
   // getters and setters for the association fields

    @ManyToOne
    @JoinColumn(name="FK_DEPT",insertable = true, updatable = false)
    public Department getDepartment() {
        return department;
    }
    public void setDepartment(Department department) {
        this.department = department;
    }
}

