/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.annotations.mapkeytemporal;

import javax.persistence.*;
import java.util.Date;
import java.util.Map;

@Entity
@Table(name="DEPARTMENT2")
public class Department2 implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  name;
    private Map lastNameEmployees;

    public Department2() {
    }

    public Department2(int id, String name) {
        this.id = id;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(targetEntity = Employee2.class, mappedBy="department")
    @MapKeyClass(Date.class)
    @MapKeyColumn(name="THEDATE")
    @MapKeyTemporal(TemporalType.DATE)
    public Map getLastNameEmployees() {
        return lastNameEmployees;
    }

    public void setLastNameEmployees(Map lastNameEmployees) {
        this.lastNameEmployees = lastNameEmployees;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getName() != null) {
            result.append(", name: " + getName());
        } else {
            result.append(", name: null");
        }
        result.append("]");
        return result.toString();
    }
}
