/*
 * Copyright (c) 2009, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.orderby;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "COLTAB")
@AttributeOverrides({
        @AttributeOverride(name = "name", column = @Column(name = "NAME"))
})
@Access(AccessType.FIELD)
public class A2 implements java.io.Serializable {

    private static final long serialVersionUID = 20L;
    @Id
    protected String id;
    protected String name;

    @ElementCollection(fetch = FetchType.EAGER)
    @CollectionTable(name = "COLTAB_ADDRESS", joinColumns = @JoinColumn(name = "A_ID"))
    @OrderBy("zipcode.zip DESC")
    protected List<Address2> lAddress = new ArrayList<Address2>();

    public A2() {
    }

    public A2(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public A2(String id, String name, List<Address2> addr) {
        this.id = id;
        this.name = name;
        this.lAddress = addr;
    }

    @Id
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Address2> getAddressList() {
        return lAddress;
    }

    public void setAddressList(List<Address2> addr) {
        this.lAddress = addr;
    }

}
