/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ListenerA.java 72034 2013-06-04 18:33:11Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.common;


import javax.persistence.*;


public class ListenerA extends ListenerAA {
    
    public ListenerA() {
        super();
    }
    
    @Override
    @PrePersist
    protected void prePersist(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerA.prePersist." + this, b);
        super.prePersist(b);
    }

    @Override
    @PostPersist
    protected void postPersist(Object b) {
        GenerictListenerImpl.logTrace("In ListenerA.postPersist." + this, (CallbackStatusIF) b);
        super.postPersist(b);
    }
    
    @Override
    @PreRemove
    protected void preRemove(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerA.prePersist." + this, b);
        super.preRemove(b);
    }
    
    @Override
    @PostRemove
    protected void postRemove(Object b) {
        GenerictListenerImpl.logTrace("In ListenerA.preRemove." + this, (CallbackStatusIF) b);
        super.postRemove(b);
    }
    
    @Override
    @PreUpdate
    protected void preUpdate(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerA.preUpdate." + this, b);
        super.preUpdate(b);
    }
    
    @Override
    @PostUpdate
    protected void postUpdate(Object b) {
        GenerictListenerImpl.logTrace("In ListenerA.postUpdate." + this, (CallbackStatusIF) b);
        super.postUpdate(b);
    }
    
    @PostLoad
    @Override
    protected void postLoad(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerA.postLoad." + this, b);
        super.postLoad(b);
    }
    
}
