/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex1a;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
@IdClass(DID1DependentId.class)
public class DID1Dependent implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id String name;
    @Id @ManyToOne DID1Employee emp;

    public DID1Dependent() {
    }

    public DID1Dependent(String name, DID1Employee emp) {
        this.name = name;
        this.emp = emp;
    }

    public DID1Employee getEmp() {
        return emp;
    }

    public void setEmp(DID1Employee emp) {
        this.emp = emp;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

   
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (name != null ? name.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID1Dependent)) {
            return false;
        }
        DID1Dependent other = (DID1Dependent) object;
        if ((this.name == null && other.name != null) || (this.name != null && !this.name.equals(other.name))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "ex1a.DID1Dependent[id=" + name + "]";
    }
}
