/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.jpa.core.entityManager;

import javax.persistence.*;

@Entity
@Table(name = "PURCHASE_ORDER")
public class Order implements java.io.Serializable {

    private int id;
    private int total;
    private String description;

    public Order() {
    }

    public Order(int total) {
        this.total = total;
    }

    public Order(String description) {
        this.description = description;
    }

    public Order(int id, int total) {
        this.id = id;
        this.total = total;
    }

    public Order(int id, int total, String description) {
        this.id = id;
        this.total = total;
        this.description = description;
    }

    @Id
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getdescription() {
        return description;
    }

    public void setdescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Order id=" + getId() + ", total=" + getTotal() + ", desc=" + getdescription();
    }

    @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Order)) return false;

        Order o1 = (Order) o;

        boolean result = false;

        if (this.getId() == o1.getId() &&
                this.getdescription().equals(o1.getdescription()) &&
                this.getTotal() == o1.getTotal()) {
            result = true;
        }

        return result;
    }
}
