/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: B.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.entitytest.persist.manyXmany;


import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.Collection;

@Entity
@Table(name="BEJB_MXM_BI_BTOB")
public class B implements java.io.Serializable {


    // ===========================================================
    // instance variables 
    @Id
    protected String id;

    @Basic
    protected String name;

    @Basic
    protected int value;

    // ===========================================================
    // relationship fields

    @ManyToMany(targetEntity=com.sun.ts.tests.jpa.core.entitytest.persist.manyXmany.A.class, cascade=CascadeType.PERSIST, mappedBy="bCol")
    protected Collection aCol = new java.util.ArrayList();

    // ===========================================================
    // constructors

    public B() {
        TestUtil.logTrace("Entity B no arg constructor");
    }

    public B(String id, String name, int value)
    {
      this.id = id;
      this.name = name;
      this.value = value;
    }

    public B(String id, String name, int value, Collection aCol)
    {
      this.id = id;
      this.name = name;
      this.value = value;
      this.aCol = aCol;
    }

    // ==========================================================
    // Business Methods for Test Cases


    public Collection getACol()
    {
        TestUtil.logTrace("getACol");
        return aCol;
    }

    public void setACol(Collection aCol)
    {
        TestUtil.logTrace("setACol");
        this.aCol = aCol;
    }

    public String getBId()
    {
	return id;
    }

    public String getBName()
    {
	return name;
    }

    public int getBValue()
    {
	return value;
    }
}
