/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.jpa.core.query.parameter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Date;


@Entity
@Table(name="EMPLOYEE")
public class Employee implements java.io.Serializable {

    private int	     	     id;
    private String	     firstName;
    private String	     lastName;
    private Date	     hireDate;
    private float	     salary;

    public Employee() {
    }

    public Employee(int id, String firstName, String lastName)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
    }
    public Employee(int id, String firstName, String lastName, Date hireDate,
			float salary)
    {
        	this.id = id;
        	this.firstName = firstName;
        	this.lastName = lastName;
		this.hireDate = hireDate;
		this.salary = salary;
    }

   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATE")
    public Date getHireDate() {
        return hireDate;
    }
    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return salary;
    }
    public void setSalary(float salary) {
        this.salary = salary;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", firstName: " + getFirstName());
        result.append(", lastName: " + getLastName());
        result.append(", hireDate: " + getHireDate());
        result.append(", salary: " + getSalary());
        result.append("]");
        return result.toString();
    }
}

