/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.relationship.bidirmanyxone;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class BiDirMX1Project implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    private Long id;
    private String name;
    private Float budget;

    public BiDirMX1Project() {
    }

    public BiDirMX1Project(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public BiDirMX1Project(long l, String string, Float aFloat) {
        this.id = l;
        this.name = string;
        this.budget = aFloat;
    }
    @OneToMany(mappedBy = "project")
    private List<BiDirMX1Person> biDirMX1Persons;

    public List<BiDirMX1Person> getBiDirMX1Persons() {
        return biDirMX1Persons;
    }

    public void setBiDirMX1Persons(List<BiDirMX1Person> biDirMX1Persons) {
        this.biDirMX1Persons = biDirMX1Persons;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof BiDirMX1Project)) {
            return false;
        }
        BiDirMX1Project other = (BiDirMX1Project) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "unimanyxone.UniMX1Project[id=" + id + "]";
    }
}
