/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestBean2.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.types.primarykey.compound;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;

@Entity
@IdClass(com.sun.ts.tests.jpa.core.types.primarykey.compound.CompoundPK2.class)
@Table(name= "PKEY")
public class TestBean2 implements java.io.Serializable{

   private Integer pmIDInteger;
   private String pmIDString;
   private Float pmIDFloat;
   private String brandName;
   private float price;

   public TestBean2() {
   }

   public TestBean2(Integer pmIDInteger, String pmIDString, Float pmIDFloat,
			 String brandName, float price) {
        this.pmIDInteger = pmIDInteger;
        this.pmIDString = pmIDString;
        this.pmIDFloat = pmIDFloat;
	this.brandName = brandName;
	this.price = price;
   }

    @Id
    public Integer getPmIDInteger() {
	return pmIDInteger;
    }
    public void setPmIDInteger(Integer intID) {
	
        this.pmIDInteger = intID;
    }

    @Id
    public String getPmIDString() {
	return pmIDString;
    }
    public void setPmIDString(String stringID) {
        this.pmIDString = stringID;
    }

    @Id
    public Float getPmIDFloat() {
	return pmIDFloat;
    }
    public void setPmIDFloat(Float floatID) {
        this.pmIDFloat = floatID;
    }

    @Basic
    public String getBrandName() {
        return brandName;
    } public void setBrandName(String v) {
        this.brandName = v;
    }

    @Basic
    public float getPrice() {
        return price;
    }
    public void setPrice(float v) {
        this.price = v;
    }


    public void ping() {
	TestUtil.logTrace("[TestBean] ping()");
    }

}

