/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.asynccontext;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncTests extends HttpServlet {

    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = {HttpServletRequest.class,
        HttpServletResponse.class
    };

    public void service(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        String test = req.getParameter(TEST_HEADER);
        try {
            Method method = this.getClass().getMethod(test, TEST_ARGS);
            method.invoke(this, new Object[]{req, res});
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void asyncTest(HttpServletRequest request,
            HttpServletResponse response) throws IOException {
        response.getWriter().println("ASYNC_STARTED_asyncTest");
        response.getWriter().println("IsAsyncSupported=" + request.isAsyncSupported());
        response.getWriter().println("IsAsyncStarted=" + request.isAsyncStarted());
        response.getWriter().println("DispatcherType=" + request.getDispatcherType());
    }
}
