/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.pluggability.common;

import java.util.ArrayList;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;

@WebListener()
public final class RequestListener7 implements ServletRequestListener {

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al != null) {
            al.add("RequestListener7 requestDestroyed");
            event.getServletContext().setAttribute("testmessage", al);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("RequestListener7 requestInitialized");
        event.getServletContext().setAttribute("testmessage", al);
    }
}
