/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.spec.security.metadatacomplete;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.annotation.security.DeclareRoles;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;


/*
 * The DD is using metadata-complete=true which means that the DD
 * security  constraints will get used and the annotation defined
 * security constraints will be ignored.
 * 
 * Using annotations, this servlet declares roles and then deny's all as a 
 * default, however GET is specified with a RolesAllowed="Administrator".
 * There is a duplicate Servlet url/context defined in the DD - which means
 * that the DD should override the annotations defined in this class.
 * The DD indicates that role Manager (user=javajoe) has perm to do GET/POST
 * requess.  This will take precedence over the annotations of this class which
 * state that role Administrator (user=j2ee) can issue GET requests.  
 */

@ServletSecurity(value = @HttpConstraint(EmptyRoleSemantic.DENY),
        httpMethodConstraints = { @HttpMethodConstraint(value = "GET", rolesAllowed = "Administrator")
         })
@WebServlet(name="GuestPageTestLogicalName",  urlPatterns={"/GuestPageTest"})
public class GuestPageTestServlet extends HttpServlet {

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() != null)) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        } else {
            out.println("Could not get principal via request.getUserPrincipal() " + "<BR>");
        }

    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() != null)) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        } else {
            out.println("Could not get principal via request.getUserPrincipal() " + "<BR>");
        }

    }

}

