/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.createlistener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent sce) {
        boolean passed = true;
        ServletContext context = sce.getServletContext();
        StringBuilder log = new StringBuilder();

        try {
            context.createListener(com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SCListener.class);
            log.append("Expected UnsupportedOperationException not thrown by createListener(SCListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by createListener(SCListener.class).");
        } catch (ServletException ex1) {
            log.append("ServletException thrown by createListener(SCListener.class).");
        }

        try {
            context.createListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SCAttributeListener.class);
            log.append("Expected UnsupportedOperationException not thrown by createListener(SCAttributeListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by createListener(SCAttributeListener.class).");
        } catch (ServletException ex1) {
            log.append("ServletException thrown by createListener(SCAttributeListener.class).");
        }

        try {
            context.createListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SRListener.class);
            log.append("Expected UnsupportedOperationException not thrown by createListener(SRListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by createListener(SRListener.class).");
        } catch (ServletException ex1) {
            log.append("ServletException thrown by createListener(SRListener.class).");
        }



        try {
            context.createListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SRAttributeListener.class);
            log.append("Expected UnsupportedOperationException not thrown by createListener(SRAttributeListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by createListener(SRAttributeListener.class).");
        } catch (ServletException ex1) {
            log.append("ServletException thrown by createListener(SRAttributeListener.class).");
        }


        context.setAttribute("TCK_TEST_STATUS", log.toString());
        context.setAttribute("TCK_TEST_PASS_STATUS", passed);
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
        // Do nothing
    }
}
