/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext40;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import java.util.List;

public class AddListener implements ServletContextListener {

  @Override
  public void contextInitialized(ServletContextEvent sce) {
    ServletContext context = sce.getServletContext();
    List list = (List)context.getAttribute("arraylist");
    try {
      ServletRegistration registration = context.addJspFile("AddJspFile2", "/addJspFile.jsp");
      list.add("addJsp_addedListener");
    } catch (UnsupportedOperationException e) {
      list.add("UnsupportedOperationException_when_addJsp_addedListener");
    }

    try {
      context.setSessionTimeout(2);
      list.add("setSessionTimeout_addedListener");
    } catch (UnsupportedOperationException e) {
      list.add("UnsupportedOperationException_when_setSessionTimeout_addedListener");
    }
    context.setAttribute("arraylist", list);
  }

  @Override
  public void contextDestroyed(ServletContextEvent sce) {

  }
}
