/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.sessiontrackingmode1;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.*;

public class TestServlet extends GenericTCKServlet {

    public void setSessionTrackingModes1(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        Boolean passed = true;
        PrintWriter pw = response.getWriter();

        ServletContext context = request.getServletContext();

        List<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.COOKIE);

        Set<SessionTrackingMode> complete_set = new HashSet(complete);

        try {
            context.setSessionTrackingModes(complete_set);
            passed = false;
            pw.println("No expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalArgumentException ilae) {
            pw.println("IllegalArgumentException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalStateException ilex) {
            pw.println("Expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (Throwable tr) {
            passed = false;
            pw.println("Unexpected Exception throw when "
                    + "setSessionTrackingModes is called.");
            pw.println(tr.getMessage());
            pw.println(tr.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setSessionTrackingModes2(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        Boolean passed = true;
        PrintWriter pw = response.getWriter();

        ServletContext context = request.getServletContext();

        List<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.URL);

        Set<SessionTrackingMode> complete_set = new HashSet(complete);

        try {
            context.setSessionTrackingModes(complete_set);
            passed = false;
            pw.println("No expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalArgumentException ilae) {
            pw.println("IllegalArgumentException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalStateException ilex) {
            pw.println("Expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (Throwable tr) {
            passed = false;
            pw.println("Unexpected Exception throw when "
                    + "setSessionTrackingModes is called.");
            pw.println(tr.getMessage());
            pw.println(tr.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setSessionTrackingModes3(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        Boolean passed = true;
        PrintWriter pw = response.getWriter();

        ServletContext context = request.getServletContext();

        List<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.SSL);

        Set<SessionTrackingMode> complete_set = new HashSet(complete);

        try {
            context.setSessionTrackingModes(complete_set);
            passed = false;
            pw.println("No expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalArgumentException ilae) {
            pw.println("IllegalArgumentException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalStateException ilex) {
            pw.println("Expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (Throwable tr) {
            passed = false;
            pw.println("Unexpected Exception throw when "
                    + "setSessionTrackingModes is called.");
            pw.println(tr.getMessage());
            pw.println(tr.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void setSessionTrackingModes4(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        Boolean passed = true;
        PrintWriter pw = response.getWriter();

        ServletContext context = request.getServletContext();

        List<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.COOKIE);
        complete.add(SessionTrackingMode.URL);

        Set<SessionTrackingMode> complete_set = new HashSet(complete);

        try {
            context.setSessionTrackingModes(complete_set);
            passed = false;
            pw.println("No expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalArgumentException ilae) {
            pw.println("IllegalArgumentException throw when "
                    + "setSessionTrackingModes is called");
        } catch (IllegalStateException ilex) {
            pw.println("Expected IllegalStateException throw when "
                    + "setSessionTrackingModes is called");
        } catch (Throwable tr) {
            passed = false;
            pw.println("Unexpected Exception throw when "
                    + "setSessionTrackingModes is called.");
            pw.println(tr.getMessage());
            pw.println(tr.toString());
        }
        ServletTestUtil.printResult(pw, passed);
    }
}
