/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.writelistener;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value = "/TestServlet", asyncSupported = true)
public class TestServlet extends HttpTCKServlet {

    private static final int LENGTH = 587952;

    public void nioOutputTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {

        AsyncContext ac = request.startAsync();
        ServletOutputStream output = response.getOutputStream();
        TestListener writeListener = new TestListener(output, ac);
        output.setWriteListener(writeListener);
    }
}
