/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.listenerorder;

import javax.servlet.*;

public class ServletRequestListener3 implements ServletRequestListener {

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest sr = sre.getServletRequest();
        if (sr.getAttribute("name_1") == null) {
            throw new IllegalStateException(
                    "Missing request attribute during requestInitialized");
        }
        if (sr.getAttribute("name_2") == null) {
            throw new IllegalStateException(
                    "Missing request attribute during requestInitialized");
        }
        sr.setAttribute("name_3", "value_3");
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest sr = sre.getServletRequest();
        if (sr.getAttribute("name_1") == null) {
            throw new IllegalStateException(
                    "Missing request attribute during requestDestroyed");
        }
        if (sr.getAttribute("name_2") == null) {
            throw new IllegalStateException(
                    "Missing request attribute during requestInitialized");
        }
        sr.removeAttribute("name_3");
    }
}
